# -------------------------------------------------------- 
# SharePoint 2013 Advanced WCM - Sample Code 
# by John Chapman
# (c) Packt Publishing
#
# Import a design package
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# VARIABLES
# Replace the variable values appropriately
# -------------------------------------------------------- 

# URL to the SharePoint site collection
$siteUrl = "http://sharepoint/sitecollection"

# Path of the design package
$filePath = "C:\Packages\My PowerShell Design-1.0.wsp" 

# Major version of the design package
$majorVersion = 1

# Minor version of the design package
$minorVersion = 0

# -------------------------------------------------------- 
# END VARIABLES
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# SCRIPT
# -------------------------------------------------------- 

# Add the SharePoint PowerShell snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

# Load the required SharePoint assemblies
[Reflection.Assembly]::LoadFrom("C:\Program Files\Common Files\microsoft shared\Web Server Extensions\15\ISAPI\Microsoft.SharePoint.Publishing.dll")
[Reflection.Assembly]::LoadFrom("C:\Program Files\Common Files\microsoft shared\Web Server Extensions\15\ISAPI\Microsoft.SharePoint.dll")

# Get the Site Collection
$site = Get-SPSite $siteUrl

# Get the File Name from the File Path
$fileName = [System.IO.Path]::GetFileName($filePath)

# Create a new Design Package Info object
$package = New-Object Microsoft.SharePoint.Publishing.DesignPackageInfo($fileName, [Guid]::Empty, $majorVersion, $minorVersion)

# Create a temporary folder in the Site Collection to upload the Design Package to
$tempFolderName = "temp_designupload_" + ([Guid]::NewGuid).ToString()
$tempFolder = $site.RootWeb.RootFolder.SubFolders.Add($tempFolderName)

# Open the contents of the File and upload to the temporary folder
$fileBinary = [System.IO.File]::OpenRead($filePath)
$file = $tempFolder.Files.Add($fileName, $fileBinary, $true)
$fileBinary.Close()

# Install the Design Package
[Microsoft.SharePoint.Publishing.DesignPackage]::Install($site, $package, $file.Url)

# Delete the temporary folder
$tempFolder.Delete()

# Dispose of the site collection object
$site.Dispose()

# -------------------------------------------------------- 
# END SCRIPT
# -------------------------------------------------------- 